<?php
header('Content-Type: application/json');
require_once '../backend/config.php';

try {
    // Check if admins table exists and has records
    $result = $conn->query("SELECT COUNT(*) as admin_count FROM admins");
    $row = $result->fetch_assoc();
    
    echo json_encode([
        'success' => true,
        'admin_exists' => $row['admin_count'] > 0,
        'admin_count' => $row['admin_count']
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Database check failed: ' . $e->getMessage(),
        'admin_exists' => false
    ]);
}
?>
