<!DOCTYPE html>
<html dir="ltr" lang="en-US">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="author" content="zytheme">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
    <meta name="description" content="Carousel Management - Granny Restaurant">
    <link href="../assets/images/favicon/favicon.png" rel="icon">

    <!-- Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Raleway:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet" type="text/css">

    <!-- Font Awesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

    <!-- Bootstrap CSS -->
    <link href="../assets/css/bootstrap.min.css" rel="stylesheet">

    <!-- SweetAlert2 CSS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">

    <title>Carousel Management - Granny Restaurant</title>

    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Raleway', sans-serif;
            background: #f5f5f5;
            color: #333;
        }

        /* Sidebar */
        .sidebar {
            position: fixed;
            left: 0;
            top: 0;
            width: 280px;
            height: 100vh;
            background: linear-gradient(135deg, #2c3e50 0%, #34495e 100%);
            color: white;
            padding: 0;
            z-index: 1000;
            overflow-y: auto;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.1);
        }

        .sidebar-header {
            padding: 30px 20px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            text-align: center;
            border-bottom: 3px solid #d4a574;
        }

        .sidebar-logo {
            font-size: 40px;
            margin-bottom: 10px;
            display: block;
        }

        .sidebar-header h2 {
            font-size: 20px;
            margin: 10px 0 5px 0;
            font-weight: 700;
        }

        .sidebar-header p {
            font-size: 12px;
            opacity: 0.9;
            margin: 0;
        }

        .admin-name {
            font-size: 11px;
            opacity: 0.8;
            margin-top: 8px;
            padding-top: 8px;
            border-top: 1px solid rgba(255, 255, 255, 0.2);
        }

        .sidebar-menu {
            list-style: none;
            padding: 20px 0;
        }

        .sidebar-menu li {
            margin: 0;
        }

        .sidebar-menu a {
            display: flex;
            align-items: center;
            gap: 15px;
            padding: 15px 25px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            transition: all 0.3s ease;
            font-weight: 500;
            border-left: 3px solid transparent;
        }

        .sidebar-menu a:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            border-left-color: #d4a574;
            padding-left: 28px;
        }

        .sidebar-menu a.active {
            background: rgba(255, 255, 255, 0.15);
            color: white;
            border-left-color: #d4a574;
        }

        .sidebar-menu i {
            width: 20px;
            text-align: center;
            font-size: 16px;
        }

        .notification-badge {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 20px;
            height: 20px;
            padding: 0 6px;
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            color: white;
            border-radius: 10px;
            font-size: 11px;
            font-weight: 700;
            margin-left: auto;
            animation: badgePulse 2s infinite;
        }

        .notification-badge.hidden {
            display: none;
        }

        @keyframes badgePulse {
            0%, 100% {
                box-shadow: 0 0 0 0 rgba(231, 76, 60, 0.7);
            }
            50% {
                box-shadow: 0 0 0 10px rgba(231, 76, 60, 0);
            }
        }

        .sidebar-footer {
            /* padding: 20px; */
            border-top: 1px solid rgba(255, 255, 255, 0.1);
            position: absolute;
            /* bottom: 0; */
            width: 100%;
        }

        .logout-btn {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #e74c3c 0%, #c0392b 100%);
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 8px;
        }

        .logout-btn:hover {
            background: linear-gradient(135deg, #c0392b 0%, #a93226 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(231, 76, 60, 0.3);
        }

        /* Topbar */
        .topbar {
            position: fixed;
            top: 0;
            left: 280px;
            right: 0;
            height: 70px;
            background: white;
            border-bottom: 1px solid #e8e8e8;
            display: flex;
            align-items: center;
            justify-content: space-between;
            padding: 0 30px;
            z-index: 999;
            box-shadow: 0 2px 4px rgba(0, 0, 0, 0.05);
        }

        .topbar-title {
            font-size: 24px;
            font-weight: 700;
            color: #2c3e50;
        }

        .topbar-right {
            display: flex;
            align-items: center;
            gap: 30px;
        }

        .topbar-user {
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .user-avatar {
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            border-radius: 50%;
            font-weight: 700;
            font-size: 18px;
        }

        .user-info p {
            font-size: 12px;
            color: #999;
            margin: 0;
        }

        .user-info strong {
            display: block;
            font-size: 14px;
            color: #2c3e50;
        }

        .menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 24px;
            cursor: pointer;
            color: #2c3e50;
        }

        /* Main Content */
        .main-content {
            margin-left: 280px;
            margin-top: 70px;
            padding: 30px;
            min-height: calc(100vh - 70px);
        }

        .content-section {
            background: white;
            border-radius: 10px;
            padding: 30px;
            margin-bottom: 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
        }

        .section-title {
            font-size: 24px;
            font-weight: 700;
            margin-bottom: 25px;
            color: #2c3e50;
            display: flex;
            align-items: center;
            gap: 15px;
        }

        .section-title i {
            color: #d4a574;
            font-size: 28px;
        }

        .btn-group {
            display: flex;
            gap: 15px;
            margin-bottom: 25px;
            flex-wrap: wrap;
        }

        .btn-action {
            padding: 12px 25px;
            background: linear-gradient(135deg, #d4a574 0%, #8b6f47 100%);
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .btn-action:hover {
            background: linear-gradient(135deg, #8b6f47 0%, #5d4a2f 100%);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(212, 165, 116, 0.3);
        }

        /* Sliders Grid */
        .sliders-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
            gap: 25px;
            margin-top: 20px;
        }

        .slider-card {
            background: white;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.08);
            transition: all 0.3s ease;
            display: flex;
            flex-direction: column;
        }

        .slider-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.15);
        }

        .slider-image {
            width: 100%;
            height: 200px;
            object-fit: cover;
        }

        .slider-info {
            padding: 20px;
            flex: 1;
            display: flex;
            flex-direction: column;
        }

        .slider-subheadline {
            font-size: 12px;
            color: #d4a574;
            font-weight: 600;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-bottom: 8px;
        }

        .slider-headline {
            font-size: 18px;
            font-weight: 700;
            color: #2c3e50;
            margin-bottom: 8px;
        }

        .slider-description {
            font-size: 13px;
            color: #666;
            margin-bottom: 12px;
            flex: 1;
        }

        .slider-status {
            display: inline-block;
            padding: 6px 12px;
            border-radius: 4px;
            font-size: 12px;
            font-weight: 600;
            margin-bottom: 12px;
            width: fit-content;
        }

        .slider-status.active {
            background: #d4edda;
            color: #155724;
        }

        .slider-status.inactive {
            background: #f8d7da;
            color: #721c24;
        }

        .slider-actions {
            display: flex;
            gap: 10px;
        }

        .btn-edit, .btn-delete, .btn-view {
            flex: 1;
            padding: 10px 15px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            font-size: 12px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 6px;
        }

        .btn-edit {
            background: #d4a574;
            color: white;
        }

        .btn-edit:hover {
            background: #8b6f47;
        }

        .btn-delete {
            background: #f8d7da;
            color: #721c24;
        }

        .btn-delete:hover {
            background: #f5c6cb;
        }

        .btn-view {
            background: #d1ecf1;
            color: #0c5460;
        }

        .btn-view:hover {
            background: #bee5eb;
        }

        /* Modal */
        .modal {
            display: none;
            position: fixed;
            z-index: 2000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            align-items: center;
            justify-content: center;
        }

        .modal-content {
            background: white;
            padding: 40px;
            border-radius: 10px;
            width: 90%;
            max-width: 600px;
            max-height: 90vh;
            overflow-y: auto;
            position: relative;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
        }

        .slider-modal {
            max-width: 700px;
        }

        .modal-content h2 {
            font-size: 24px;
            color: #2c3e50;
            margin-bottom: 25px;
        }

        .close-modal {
            position: absolute;
            right: 20px;
            top: 20px;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            color: #999;
            transition: color 0.3s ease;
        }

        .close-modal:hover {
            color: #333;
        }

        /* Forms */
        .form-group {
            margin-bottom: 20px;
        }

        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #2c3e50;
            font-size: 14px;
        }

        .form-group input,
        .form-group textarea,
        .form-group select {
            padding: 12px;
            border: 1px solid #e0e0e0;
            border-radius: 6px;
            font-size: 14px;
            font-family: inherit;
            transition: border-color 0.3s ease;
            width: 100%;
        }

        .form-group input:focus,
        .form-group textarea:focus,
        .form-group select:focus {
            outline: none;
            border-color: #d4a574;
            box-shadow: 0 0 0 3px rgba(212, 165, 116, 0.1);
        }

        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 20px;
        }

        .form-row .full-width {
            grid-column: 1 / -1;
        }

        .image-upload-wrapper {
            position: relative;
            border: 2px dashed #d4a574;
            border-radius: 8px;
            padding: 20px;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
            background: #fafafa;
        }

        .image-upload-wrapper:hover {
            border-color: #8b6f47;
            background: #f5f5f5;
        }

        .image-upload-wrapper input[type="file"] {
            display: none;
        }

        .image-upload-wrapper::after {
            content: '📁 Click to upload or drag image here';
            display: block;
            color: #666;
            font-size: 14px;
        }

        .image-preview-container {
            display: flex;
            flex-direction: column;
            align-items: center;
            gap: 12px;
            padding: 15px 0 0 0;
        }

        .btn-remove-image {
            padding: 8px 16px;
            background: #c0392b;
            color: white;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 12px;
            font-weight: 600;
            transition: all 0.3s ease;
        }

        .btn-remove-image:hover {
            background: #a93226;
        }

        .form-actions {
            display: flex;
            gap: 15px;
            margin-top: 25px;
            padding-top: 25px;
            border-top: 1px solid #e0e0e0;
        }

        .form-actions button {
            flex: 1;
            padding: 12px 25px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 600;
            font-size: 14px;
            transition: all 0.3s ease;
        }

        .btn-action-secondary {
            background: #f0f0f0;
            color: #333;
            border: 1px solid #e0e0e0;
        }

        .btn-action-secondary:hover {
            background: #e0e0e0;
        }

        /* Overlay for mobile menu */
        .overlay {
            display: none;
            position: fixed;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.3);
            z-index: 900;
        }

        .overlay.active {
            display: block;
        }

        .sidebar.active {
            transform: translateX(0);
        }

        @media (max-width: 1024px) {
            .sidebar {
                width: 250px;
            }

            .topbar {
                left: 250px;
            }

            .main-content {
                margin-left: 250px;
            }
        }

        @media (max-width: 768px) {
            .sidebar {
                position: fixed;
                left: 0;
                top: 0;
                width: 280px;
                height: 100vh;
                transform: translateX(-100%);
                transition: transform 0.3s ease;
                z-index: 1000;
            }

            .topbar {
                left: 0;
            }

            .main-content {
                margin-left: 0;
            }

            .menu-toggle {
                display: block;
            }

            .sliders-grid {
                grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
                gap: 20px;
            }

            .modal-content {
                padding: 30px;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .form-actions {
                flex-direction: column;
            }
        }

        @media (max-width: 576px) {
            .sliders-grid {
                grid-template-columns: 1fr;
            }

            .slider-card {
                flex-direction: column;
            }

            .slider-image {
                width: 100%;
                height: 200px;
            }

            .slider-info {
                padding: 15px;
            }

            .slider-headline {
                font-size: 16px;
            }

            .slider-actions {
                display: grid;
                grid-template-columns: 1fr 1fr;
                gap: 8px;
                width: 100%;
            }

            .btn-edit, .btn-delete, .btn-view {
                padding: 12px 10px;
                font-size: 12px;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
            }

            .btn-edit span, .btn-delete span, .btn-view span {
                display: none;
            }

            .btn-edit i, .btn-delete i, .btn-view i {
                margin: 0;
            }

            .modal-content {
                padding: 20px;
                width: 95%;
            }

            .topbar-title {
                font-size: 18px;
            }

            .main-content {
                padding: 15px;
            }
        }

        @media (max-width: 480px) {
            .slider-actions {
                display: flex;
                flex-direction: column;
                gap: 8px;
                width: 100%;
            }

            .btn-edit, .btn-delete, .btn-view {
                padding: 10px 12px;
                font-size: 13px;
                width: 100%;
            }

            .btn-edit span, .btn-delete span, .btn-view span {
                display: inline;
            }

            .btn-edit i, .btn-delete i, .btn-view i {
                margin-right: 4px;
            }
        }
    </style>
</head>

<body>
    <!-- Overlay for mobile menu -->
    <div id="menuOverlay" class="overlay"></div>

    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-header">
            <i class="fas fa-crown sidebar-logo"></i>
            <h2>Admin Portal</h2>
            <p>Granny Restaurant</p>
            <div class="admin-name" id="sidebarAdminName">Admin</div>
        </div>

        <ul class="sidebar-menu">
            <li><a href="dashboard.php"><i class="fas fa-chart-line"></i> <span>Dashboard</span></a></li>
            <li><a href="carousel.php" class="active"><i class="fas fa-images"></i> <span>Carousel</span></a></li>
            <li><a href="gallery.php"><i class="fas fa-th-large"></i> <span>Gallery</span></a></li>
            <li><a href="chefs.php"><i class="fas fa-user-tie"></i> <span>Chefs</span></a></li>
            <li><a href="menu.php"><i class="fas fa-utensils"></i> <span>Menu</span></a></li>
            <li><a href="bookings.php"><i class="fas fa-calendar-check"></i> <span>Bookings</span><span class="notification-badge hidden" data-type="bookings">0</span></a></li>
            <li><a href="orders.php"><i class="fas fa-shopping-cart"></i> <span>Orders</span><span class="notification-badge hidden" data-type="orders">0</span></a></li>
            <li><a href="contacts.php"><i class="fas fa-envelope"></i> <span>Contacts</span><span class="notification-badge hidden" data-type="contacts">0</span></a></li>
            <li><a href="feedback.php"><i class="fas fa-comments"></i> <span>Feedback</span><span class="notification-badge hidden" data-type="feedback">0</span></a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> <span>Users</span></a></li>
            <li><a href="settings.php"><i class="fas fa-cog"></i> <span>Settings</span></a></li>
        </ul>

        <div class="sidebar-footer">
            <button class="logout-btn" id="logoutBtn">
                <i class="fas fa-sign-out-alt"></i> Logout
            </button>
        </div>
    </div>

    <!-- Top Header -->
    <div class="topbar">
        <div style="display: flex; align-items: center; gap: 20px;">
            <button class="menu-toggle" id="menuToggle">
                <i class="fas fa-bars"></i>
            </button>
            <div class="topbar-title">Carousel Sliders</div>
        </div>

        <div class="topbar-right">
            <div class="topbar-user">
                <div class="user-avatar" id="userInitial">A</div>
                <div class="user-info">
                    <p>Welcome back</p>
                    <strong id="topbarUserName">Admin</strong>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <div class="content-section">
            <div class="section-title">
                <i class="fas fa-images"></i>
                Manage Carousel Sliders
            </div>
            <div class="btn-group">
                <button class="btn-action" id="addSliderBtn">
                    <i class="fas fa-plus"></i> Add New Slider
                </button>
            </div>

            <!-- Slider List -->
            <div id="slidersContainer" class="sliders-grid">
                <p style="text-align: center; color: #999; padding: 40px;">Loading sliders...</p>
            </div>
        </div>
    </div>

    <!-- Add/Edit Slider Modal -->
    <div id="sliderModal" class="modal" style="display: none;">
        <div class="modal-content slider-modal">
            <span class="close-modal">&times;</span>
            <h2 id="modalTitle">Add New Slider</h2>
            
            <form id="sliderForm">
                <div class="form-group">
                    <label for="sliderId" style="display: none;">Slider ID</label>
                    <input type="hidden" id="sliderId">
                </div>

                <div class="form-row">
                    <div class="form-group full-width">
                        <label for="slideSubheadline">Sub Headline</label>
                        <input type="text" id="slideSubheadline" placeholder="e.g., Granny Offers You" required>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group full-width">
                        <label for="slideHeadline">Main Headline *</label>
                        <input type="text" id="slideHeadline" placeholder="e.g., The Best Tasting Experience!" required>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group full-width">
                        <label for="slideDescription">Description</label>
                        <textarea id="slideDescription" placeholder="Slide description text" rows="3"></textarea>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="slideButtonText">Button Text</label>
                        <input type="text" id="slideButtonText" placeholder="e.g., Reservation Now">
                    </div>
                    <div class="form-group">
                        <label for="slideButtonLink">Button Link</label>
                        <input type="text" id="slideButtonLink" placeholder="e.g., #" value="#">
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group">
                        <label for="slideButtonStyle">Button Style</label>
                        <select id="slideButtonStyle">
                            <option value="btn--primary">Primary</option>
                            <option value="btn--white">White</option>
                            <option value="btn--white btn--bordered">White Bordered</option>
                            <option value="btn--white btn--bordered btn--lg">White Bordered Large</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="slideIsActive">Status</label>
                        <select id="slideIsActive">
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                    </div>
                </div>

                <div class="form-row">
                    <div class="form-group full-width">
                        <label for="slideImage">Slider Image *</label>
                        <div class="image-upload-wrapper">
                            <input type="file" id="slideImage" accept="image/*" required>
                            <div class="image-preview-container" id="imagePreviewContainer" style="display: none;">
                                <img id="imagePreview" src="" alt="Preview" style="max-width: 300px; max-height: 200px; border-radius: 8px;">
                                <button type="button" class="btn-remove-image" id="removeImageBtn">Remove Image</button>
                            </div>
                            <input type="hidden" id="slideImagePath">
                        </div>
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-action" id="submitBtn">Add Slider</button>
                    <button type="button" class="btn-action-secondary" id="cancelBtn">Cancel</button>
                </div>
            </form>
        </div>
    </div>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js"></script>

    <!-- Carousel Management Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Check admin authentication
            const adminUser = localStorage.getItem('admin_user');
            if (!adminUser) {
                window.location.href = 'login.php';
                return;
            }

            const admin = JSON.parse(adminUser);
            
            // Update header with admin info
            document.getElementById('sidebarAdminName').textContent = admin.name;
            document.getElementById('topbarUserName').textContent = admin.name;
            document.getElementById('userInitial').textContent = admin.name.charAt(0).toUpperCase();

            // Load sliders on page load
            loadSliders();

            // Mobile menu toggle
            const menuToggle = document.getElementById('menuToggle');
            const sidebar = document.getElementById('sidebar');
            const overlay = document.getElementById('menuOverlay');

            if (menuToggle && sidebar && overlay) {
                menuToggle.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    sidebar.classList.toggle('active');
                    overlay.classList.toggle('active');
                });

                overlay.addEventListener('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    sidebar.classList.remove('active');
                    overlay.classList.remove('active');
                });

                document.addEventListener('click', function(e) {
                    if (sidebar.classList.contains('active') && 
                        !sidebar.contains(e.target) && 
                        !menuToggle.contains(e.target)) {
                        sidebar.classList.remove('active');
                        overlay.classList.remove('active');
                    }
                });
            }

            // Logout
            document.getElementById('logoutBtn').addEventListener('click', function() {
                Swal.fire({
                    icon: 'warning',
                    title: 'Confirm Logout',
                    text: 'Are you sure you want to logout?',
                    showCancelButton: true,
                    confirmButtonColor: '#d4a574',
                    cancelButtonColor: '#999',
                    confirmButtonText: 'Yes, Logout',
                    cancelButtonText: 'Cancel'
                }).then((result) => {
                    if (result.isConfirmed) {
                        localStorage.removeItem('admin_user');
                        localStorage.removeItem('admin_token');
                        
                        fetch('../backend/admin_logout.php', {
                            method: 'POST'
                        }).then(() => {
                            window.location.href = 'login.php';
                        });
                    }
                });
            });

            // Load notification counts
            loadNotificationCounts();
            setInterval(loadNotificationCounts, 30000);
        });

        // ========== SLIDER MANAGEMENT ==========
        const sliderModal = document.getElementById('sliderModal');
        const addSliderBtn = document.getElementById('addSliderBtn');
        const cancelBtn = document.getElementById('cancelBtn');
        const closeModal = document.querySelector('.close-modal');
        const sliderForm = document.getElementById('sliderForm');
        const slideImage = document.getElementById('slideImage');
        const imagePreview = document.getElementById('imagePreview');
        const imagePreviewContainer = document.getElementById('imagePreviewContainer');
        const removeImageBtn = document.getElementById('removeImageBtn');
        const slideImagePath = document.getElementById('slideImagePath');

        // Open modal for adding new slider
        addSliderBtn.addEventListener('click', () => {
            resetSliderForm();
            document.getElementById('modalTitle').textContent = 'Add New Slider';
            document.getElementById('submitBtn').textContent = 'Add Slider';
            sliderModal.style.display = 'flex';
        });

        // Close modal
        cancelBtn.addEventListener('click', () => {
            sliderModal.style.display = 'none';
        });

        closeModal.addEventListener('click', () => {
            sliderModal.style.display = 'none';
        });

        sliderModal.addEventListener('click', (e) => {
            if (e.target === sliderModal) {
                sliderModal.style.display = 'none';
            }
        });

        // Make upload wrapper clickable
        const imageUploadWrapper = document.querySelector('.image-upload-wrapper');
        if (imageUploadWrapper) {
            imageUploadWrapper.addEventListener('click', (e) => {
                if (e.target.tagName !== 'BUTTON') {
                    slideImage.click();
                }
            });
        }

        // Image upload handler
        slideImage.addEventListener('change', (e) => {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = (event) => {
                    imagePreview.src = event.target.result;
                    imagePreviewContainer.style.display = 'flex';
                };
                reader.readAsDataURL(file);
            }
        });

        // Remove image
        removeImageBtn.addEventListener('click', (e) => {
            e.preventDefault();
            slideImage.value = '';
            slideImagePath.value = '';
            imagePreviewContainer.style.display = 'none';
        });

        // Submit slider form
        sliderForm.addEventListener('submit', async (e) => {
            e.preventDefault();
            const sliderId = document.getElementById('sliderId').value;
            const isEditing = !!sliderId;

            let imagePath = slideImagePath.value;
            if (slideImage.files.length > 0) {
                const formData = new FormData();
                formData.append('image', slideImage.files[0]);
                
                try {
                    const response = await fetch('../backend/sliders_api.php?action=upload_image', {
                        method: 'POST',
                        body: formData
                    });
                    const result = await response.json();
                    if (result.success) {
                        imagePath = result.data.path;
                    } else {
                        Swal.fire('Error', result.message, 'error');
                        return;
                    }
                } catch (error) {
                    Swal.fire('Error', 'Failed to upload image', 'error');
                    return;
                }
            }

            if (!imagePath) {
                Swal.fire('Error', 'Please select an image', 'error');
                return;
            }

            const sliderData = {
                image_path: imagePath,
                subheadline: document.getElementById('slideSubheadline').value,
                headline: document.getElementById('slideHeadline').value,
                description: document.getElementById('slideDescription').value,
                button_text: document.getElementById('slideButtonText').value,
                button_link: document.getElementById('slideButtonLink').value,
                button_style: document.getElementById('slideButtonStyle').value,
                is_active: parseInt(document.getElementById('slideIsActive').value)
            };

            if (isEditing) {
                sliderData.id = sliderId;
            }

            const url = isEditing ? '../backend/sliders_api.php?action=update' : '../backend/sliders_api.php?action=create';
            const method = 'POST';

            try {
                const response = await fetch(url, {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify(sliderData)
                });

                const result = await response.json();
                if (result.success) {
                    Swal.fire('Success', isEditing ? 'Slider updated successfully' : 'Slider created successfully', 'success');
                    sliderModal.style.display = 'none';
                    loadSliders();
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            } catch (error) {
                Swal.fire('Error', 'Failed to save slider', 'error');
                console.error(error);
            }
        });

        // Load all sliders
        async function loadSliders() {
            try {
                const response = await fetch('../backend/sliders_api.php?action=get_all');
                const result = await response.json();
                
                const container = document.getElementById('slidersContainer');
                
                if (result.success && result.data.length > 0) {
                    container.innerHTML = result.data.map(slider => `
                        <div class="slider-card" data-id="${slider.id}">
                            <img src="../${slider.image_path}" alt="${slider.headline}" class="slider-image">
                            <div class="slider-info">
                                <div class="slider-subheadline">${slider.subheadline || 'N/A'}</div>
                                <h3 class="slider-headline">${slider.headline}</h3>
                                <p class="slider-description">${slider.description ? slider.description.substring(0, 100) + '...' : 'No description'}</p>
                                <span class="slider-status ${slider.is_active ? 'active' : 'inactive'}">
                                    ${slider.is_active ? 'Active' : 'Inactive'}
                                </span>
                                <div class="slider-actions">
                                    <button class="btn-edit" onclick="editSlider(${slider.id})">
                                        <i class="fas fa-edit"></i> Edit
                                    </button>
                                    <button class="btn-delete" onclick="deleteSlider(${slider.id})">
                                        <i class="fas fa-trash"></i> Delete
                                    </button>
                                </div>
                            </div>
                        </div>
                    `).join('');
                } else {
                    container.innerHTML = '<p style="grid-column: 1/-1; text-align: center; color: #999; padding: 40px;">No sliders found. Add one to get started!</p>';
                }
            } catch (error) {
                console.error('Error loading sliders:', error);
                document.getElementById('slidersContainer').innerHTML = '<p style="color: #c0392b; text-align: center;">Failed to load sliders</p>';
            }
        }

        // Edit slider
        async function editSlider(id) {
            try {
                const response = await fetch(`../backend/sliders_api.php?action=get&id=${id}`);
                const result = await response.json();
                
                if (result.success) {
                    const slider = result.data;
                    
                    document.getElementById('sliderId').value = slider.id;
                    document.getElementById('slideSubheadline').value = slider.subheadline || '';
                    document.getElementById('slideHeadline').value = slider.headline;
                    document.getElementById('slideDescription').value = slider.description || '';
                    document.getElementById('slideButtonText').value = slider.button_text || '';
                    document.getElementById('slideButtonLink').value = slider.button_link || '#';
                    document.getElementById('slideButtonStyle').value = slider.button_style || 'btn--primary';
                    document.getElementById('slideIsActive').value = slider.is_active;
                    document.getElementById('slideImagePath').value = slider.image_path;
                    
                    imagePreview.src = '../' + slider.image_path;
                    imagePreviewContainer.style.display = 'flex';
                    slideImage.required = false;
                    
                    document.getElementById('modalTitle').textContent = 'Edit Slider';
                    document.getElementById('submitBtn').textContent = 'Update Slider';
                    sliderModal.style.display = 'flex';
                } else {
                    Swal.fire('Error', result.message, 'error');
                }
            } catch (error) {
                Swal.fire('Error', 'Failed to load slider', 'error');
                console.error(error);
            }
        }

        // Delete slider
        async function deleteSlider(id) {
            const result = await Swal.fire({
                title: 'Delete Slider?',
                text: 'This action cannot be undone.',
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#c0392b',
                cancelButtonColor: '#999',
                confirmButtonText: 'Delete',
                cancelButtonText: 'Cancel'
            });

            if (result.isConfirmed) {
                try {
                    const response = await fetch('../backend/sliders_api.php?action=delete', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json'
                        },
                        body: JSON.stringify({ id: id })
                    });

                    const deleteResult = await response.json();
                    if (deleteResult.success) {
                        Swal.fire('Deleted', 'Slider deleted successfully', 'success');
                        loadSliders();
                    } else {
                        Swal.fire('Error', deleteResult.message, 'error');
                    }
                } catch (error) {
                    Swal.fire('Error', 'Failed to delete slider', 'error');
                    console.error(error);
                }
            }
        }

        // Reset slider form
        function resetSliderForm() {
            sliderForm.reset();
            document.getElementById('sliderId').value = '';
            slideImagePath.value = '';
            imagePreviewContainer.style.display = 'none';
            slideImage.required = true;
        }

        // Load notification counts and update badges
        function loadNotificationCounts() {
            fetch('../backend/admin_bookings_api.php?action=new_count')
                .then(response => response.json())
                .then(data => {
                    updateBadge('bookings', data.count);
                })
                .catch(error => console.error('Error loading bookings count:', error));

            fetch('../backend/admin_orders_api.php?action=new_count')
                .then(response => response.json())
                .then(data => {
                    updateBadge('orders', data.count);
                })
                .catch(error => console.error('Error loading orders count:', error));

            fetch('../backend/admin_contacts_api.php?action=new_count')
                .then(response => response.json())
                .then(data => {
                    updateBadge('contacts', data.count);
                })
                .catch(error => console.error('Error loading contacts count:', error));

            fetch('../backend/admin_feedback_api.php?action=new_count')
                .then(response => response.json())
                .then(data => {
                    updateBadge('feedback', data.count);
                })
                .catch(error => console.error('Error loading feedback count:', error));

            fetch('../backend/admin_users_api.php?action=new_count')
                .then(response => response.json())
                .then(data => {
                    updateBadge('users', data.count);
                })
                .catch(error => console.error('Error loading users count:', error));
        }

        function updateBadge(type, count) {
            const badge = document.querySelector(`.notification-badge[data-type="${type}"]`);
            if (badge) {
                if (count > 0) {
                    badge.textContent = count > 99 ? '99+' : count;
                    badge.classList.remove('hidden');
                } else {
                    badge.classList.add('hidden');
                }
            }
        }
    </script>
</body>

</html>
