<?php
/**
 * Admin Authentication Check
 * Returns authentication status and user info if authenticated
 */

header('Content-Type: application/json');

// Start session to check if admin is logged in
session_start();

// Check if admin is logged in - check for admin_id which is always set
if (isset($_SESSION['admin_id']) && !empty($_SESSION['admin_id'])) {
    // Admin is authenticated via session
    $user = [
        'id' => $_SESSION['admin_id'],
        'name' => $_SESSION['admin_name'] ?? 'Admin',
        'email' => $_SESSION['admin_email'] ?? '',
        'phone' => $_SESSION['admin_phone'] ?? '',
        'position' => $_SESSION['admin_position'] ?? '',
        'permission_level' => $_SESSION['admin_permission'] ?? 0
    ];
    
    echo json_encode([
        'authenticated' => true,
        'user' => $user,
        'message' => 'Admin authenticated via session'
    ]);
} else {
    // Not authenticated
    echo json_encode([
        'authenticated' => false,
        'user' => null,
        'message' => 'Not authenticated'
    ]);
}
?>