# Kitchen Staff Login System - Implementation Guide

## ✅ Completed Setup

Your kitchen staff login system has been successfully created using the existing `chef` table. Here's what was implemented:

## Phase 1: Database Setup - ✅ COMPLETE

The `chefs` table has been extended with the following authentication fields:
- `email` - Staff email address
- `password` - Hashed password for login
- `employee_id` - Unique employee identifier
- `role` - Staff role (Chef, Kitchen Manager, Staff)
- `status` - Active/Inactive status

## Phase 2: Kitchen Staff Authentication - ✅ COMPLETE

### Files Created:

1. **kitchen/login.php** - Kitchen staff login page
   - Clean, modern login interface
   - Email or Employee ID login option
   - "Remember me" functionality
   
2. **backend/kitchen_signin.php** - Authentication API
   - Validates credentials against chef table
   - Creates secure session
   - Returns staff information
   
3. **backend/kitchen_session_check.php** - Session validator
   - Verifies active kitchen staff session
   - Checks session timeout (30 minutes default)
   - Returns staff details if valid

4. **backend/kitchen_logout.php** - Logout handler
   - Clears all kitchen staff sessions
   - Destroys session data securely

## Phase 3: Kitchen Dashboard Security - ✅ COMPLETE

The kitchen/dashboard.php has been updated with:
- Automatic authentication check on page load
- Redirects to login if not authenticated
- Updated logout button to use kitchen_logout.php
- Session variables for staff information

## Phase 4: Admin Panel Enhancement - ✅ COMPLETE

### Files Created:

1. **admin/kitchen_staff.php** - Kitchen staff management panel
   - View all kitchen staff members
   - Add new staff with login credentials
   - Edit existing staff details
   - Change staff status
   - Delete staff accounts

2. **backend/admin_kitchen_staff_api.php** - CRUD API
   - Create new kitchen staff (hashes passwords)
   - Update staff information
   - Delete staff accounts
   - Retrieve staff details

## 🚀 Quick Start Guide

### Step 1: Create Your First Kitchen Staff Account

1. Go to **Admin Panel** → **Kitchen Staff**
2. Click **"Add Kitchen Staff"**
3. Fill in the form:
   - **Name**: Chef's name
   - **Email**: Unique email address
   - **Employee ID**: Unique employee ID
   - **Position**: Chef / Sous Chef / Line Cook / Kitchen Assistant / Pastry Chef
   - **Role**: Chef / Kitchen Manager / Staff
   - **Password**: Strong password
   - **Status**: Active
4. Click **Save**

### Step 2: Kitchen Staff Login

1. Employees go to: `http://your-domain/rest_table/kitchen/login.php`
2. Enter either:
   - Email address + password, OR
   - Employee ID + password
3. Optional: Check "Remember me" for 30-day session
4. Click "Sign In"

### Step 3: Kitchen Dashboard Access

After login, kitchen staff can:
- View pending orders
- Update order status
- View recipes and ingredients
- Check ingredient stock availability
- Mark orders complete

## 📋 Database Schema

Your `chefs` table now has:

```
id (PRIMARY KEY)
name 
email (UNIQUE)
password (HASHED)
employee_id (UNIQUE)
position
role
status (active/inactive)
description
image_path
display_order
created_at
updated_at
```

## 🔒 Security Features

1. **Password Hashing**: All passwords are hashed using PHP's PASSWORD_BCRYPT
2. **Session Management**: Automatic session timeout after 30 minutes of inactivity
3. **Authentication Check**: Dashboard redirects to login if not authenticated
4. **Admin Authentication**: Staff management requires admin login
5. **Prepared Statements**: All database queries use prepared statements to prevent SQL injection

## 🎯 Features

### For Kitchen Staff:
- ✅ Secure login with email or employee ID
- ✅ Remember me option (30-day session)
- ✅ View assigned orders
- ✅ Update order status
- ✅ View recipes with ingredients
- ✅ Check ingredient stock levels
- ✅ Secure logout

### For Admin:
- ✅ Add new kitchen staff
- ✅ Edit staff details
- ✅ Manage staff roles and positions
- ✅ Activate/deactivate staff accounts
- ✅ Delete staff records
- ✅ Password management

## 🔧 Configuration Options

### Session Timeout
Edit `backend/kitchen_session_check.php` line 15:
```php
$timeout = 30 * 60; // Change 30 to desired minutes
```

### Password Requirements
Add validation in `admin/kitchen_staff.php` if needed

### Available Roles
Edit the role select in `admin/kitchen_staff.php`:
- Chef
- Kitchen Manager
- Staff
- (Add more as needed)

## 🐛 Troubleshooting

### "Not authenticated" error on dashboard
- Make sure you're logged in via `/kitchen/login.php`
- Check if session cookie is enabled in browser
- Clear browser cookies and try again

### "Invalid credentials" on login
- Verify email/employee ID is correct
- Check if account status is "active"
- Verify password is correct

### Password is incorrect after resetting
- Admin must set a new password via "Edit Staff"
- Passwords cannot be recovered, only reset

## 📞 Support

For issues or questions, contact your system administrator.

---

**Implementation Date**: Feb 24, 2026  
**System**: Granny Restaurant Management System  
**Version**: 1.0
